CREATE PROCEDURE usp_Insert_MedRed_L_Test
AS
BEGIN


BEGIN
INSERT INTO [V5_Registry].[dbo].[STD_SURVEY_TYPE]
           ([CODE],[NAME],[DESCRIPTION_TEXT],[CREATEDBY],[UPDATEDBY],[CREATED],[UPDATED])
     VALUES
           ('MRL', 'MedRed - L Test', 'MedRed - L Test', 'Initial', 'Initial', GETDATE(), GETDATE())
END

BEGIN
declare @type     int;


SELECT @type=  (SELECT ID [STD_SURVEY_TYPE_ID]
FROM STD_SURVEY_TYPE
WHERE CODE = 'MRL')

INSERT INTO [V5_Registry].[dbo].[STD_QUESTION]
           ([STD_SURVEY_TYPE_ID],[QUESTION_NUMBER],[QUESTION_TEXT],[SORT_ORDER],[CREATEDBY],[CREATED],[UPDATEDBY],[UPDATED],[INACTIVE_FLAG],[INACTIVE_DATE])
     VALUES
           (@type, '1', 'Lower extremity amputation:', 1, 'InitialLoad', GETDATE(), 'InitialLoad', GETDATE(),0, NULL)

INSERT INTO [V5_Registry].[dbo].[STD_QUESTION]
           ([STD_SURVEY_TYPE_ID],[QUESTION_NUMBER],[QUESTION_TEXT],[SORT_ORDER],[CREATEDBY],[CREATED],[UPDATEDBY],[UPDATED],[INACTIVE_FLAG],[INACTIVE_DATE])
     VALUES
           (@type, '2', 'If Yes  user can select level from following', 2, 'InitialLoad', GETDATE(), 'InitialLoad', GETDATE(),0, NULL)

INSERT INTO [V5_Registry].[dbo].[STD_QUESTION]
           ([STD_SURVEY_TYPE_ID],[QUESTION_NUMBER],[QUESTION_TEXT],[SORT_ORDER],[CREATEDBY],[CREATED],[UPDATEDBY],[UPDATED],[INACTIVE_FLAG],[INACTIVE_DATE])
     VALUES
           (@type, '3', 'Assistive device:', 3, 'InitialLoad', GETDATE(), 'InitialLoad', GETDATE(),0, NULL)

INSERT INTO [V5_Registry].[dbo].[STD_QUESTION]
           ([STD_SURVEY_TYPE_ID],[QUESTION_NUMBER],[QUESTION_TEXT],[SORT_ORDER],[CREATEDBY],[CREATED],[UPDATEDBY],[UPDATED],[INACTIVE_FLAG],[INACTIVE_DATE])
     VALUES
           (@type, '4', 'If Yes  user can select one of Walker/Rolling Walker/Crutches/Cane', 4, 'InitialLoad', GETDATE(), 'InitialLoad', GETDATE(),0, NULL)

INSERT INTO [V5_Registry].[dbo].[STD_QUESTION]
           ([STD_SURVEY_TYPE_ID],[QUESTION_NUMBER],[QUESTION_TEXT],[SORT_ORDER],[CREATEDBY],[CREATED],[UPDATEDBY],[UPDATED],[INACTIVE_FLAG],[INACTIVE_DATE])
     VALUES
           (@type, '5', 'Physical Assistance:', 5, 'InitialLoad', GETDATE(), 'InitialLoad', GETDATE(),0, NULL)

INSERT INTO [V5_Registry].[dbo].[STD_QUESTION]
           ([STD_SURVEY_TYPE_ID],[QUESTION_NUMBER],[QUESTION_TEXT],[SORT_ORDER],[CREATEDBY],[CREATED],[UPDATEDBY],[UPDATED],[INACTIVE_FLAG],[INACTIVE_DATE])
     VALUES
           (@type, '6', 'Trial 1: Time', 6, 'InitialLoad', GETDATE(), 'InitialLoad', GETDATE(),0, NULL)

INSERT INTO [V5_Registry].[dbo].[STD_QUESTION]
           ([STD_SURVEY_TYPE_ID],[QUESTION_NUMBER],[QUESTION_TEXT],[SORT_ORDER],[CREATEDBY],[CREATED],[UPDATEDBY],[UPDATED],[INACTIVE_FLAG],[INACTIVE_DATE])
     VALUES
           (@type, '7', 'Trial 1:Distance', 7, 'InitialLoad', GETDATE(), 'InitialLoad', GETDATE(),0, NULL)

INSERT INTO [V5_Registry].[dbo].[STD_QUESTION]
           ([STD_SURVEY_TYPE_ID],[QUESTION_NUMBER],[QUESTION_TEXT],[SORT_ORDER],[CREATEDBY],[CREATED],[UPDATEDBY],[UPDATED],[INACTIVE_FLAG],[INACTIVE_DATE])
     VALUES
           (@type, '8', 'Trial 2: Time', 8, 'InitialLoad', GETDATE(), 'InitialLoad', GETDATE(),0, NULL)

INSERT INTO [V5_Registry].[dbo].[STD_QUESTION]
           ([STD_SURVEY_TYPE_ID],[QUESTION_NUMBER],[QUESTION_TEXT],[SORT_ORDER],[CREATEDBY],[CREATED],[UPDATEDBY],[UPDATED],[INACTIVE_FLAG],[INACTIVE_DATE])
     VALUES
           (@type, '9', 'Trial 2:Distance', 9, 'InitialLoad', GETDATE(), 'InitialLoad', GETDATE(),0, NULL)

INSERT INTO [V5_Registry].[dbo].[STD_QUESTION]
           ([STD_SURVEY_TYPE_ID],[QUESTION_NUMBER],[QUESTION_TEXT],[SORT_ORDER],[CREATEDBY],[CREATED],[UPDATEDBY],[UPDATED],[INACTIVE_FLAG],[INACTIVE_DATE])
     VALUES
           (@type, '10', 'Unstable on turning?', 10, 'InitialLoad', GETDATE(), 'InitialLoad', GETDATE(),0, NULL)

INSERT INTO [V5_Registry].[dbo].[STD_QUESTION]
           ([STD_SURVEY_TYPE_ID],[QUESTION_NUMBER],[QUESTION_TEXT],[SORT_ORDER],[CREATEDBY],[CREATED],[UPDATEDBY],[UPDATED],[INACTIVE_FLAG],[INACTIVE_DATE])
     VALUES
           (@type, '11', 'Test Date', 11, 'InitialLoad', GETDATE(), 'InitialLoad', GETDATE(),0, NULL)

INSERT INTO [V5_Registry].[dbo].[STD_QUESTION]
           ([STD_SURVEY_TYPE_ID],[QUESTION_NUMBER],[QUESTION_TEXT],[SORT_ORDER],[CREATEDBY],[CREATED],[UPDATEDBY],[UPDATED],[INACTIVE_FLAG],[INACTIVE_DATE])
     VALUES
           (@type, '12', 'Average Time:', 12, 'InitialLoad', GETDATE(), 'InitialLoad', GETDATE(),0, NULL)

INSERT INTO [V5_Registry].[dbo].[STD_QUESTION]
           ([STD_SURVEY_TYPE_ID],[QUESTION_NUMBER],[QUESTION_TEXT],[SORT_ORDER],[CREATEDBY],[CREATED],[UPDATEDBY],[UPDATED],[INACTIVE_FLAG],[INACTIVE_DATE])
     VALUES
           (@type, '13', 'Average Distance:', 13, 'InitialLoad', GETDATE(), 'InitialLoad', GETDATE(),0, NULL)
           
END
 
 
BEGIN

declare @question     int, 
        @maxchoice    int,
        @choice       int;
        
--------Question 1  
 
SELECT @question=  (SELECT q.ID  
FROM STD_QUESTION q
    ,STD_SURVEY_TYPE t
WHERE CODE = 'MRL' AND t.ID = q.STD_SURVEY_TYPE_ID AND q.SORT_ORDER = 1)
----1
SET @choice = ((SELECT MAX(STD_QUESTION_CHOICE_ID) from [V5_Registry].[dbo].[STD_QUESTION_CHOICE]) + 1)

INSERT INTO [V5_Registry].[dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, 'Yes' ,'Yes', 2, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())
----2
SET @choice = @choice + 1 

INSERT INTO [V5_Registry].[dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, 'No', 'No', 1, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())
           
--------Question 2

SELECT @question=  (SELECT q.ID  
FROM STD_QUESTION q
    ,STD_SURVEY_TYPE t
WHERE CODE = 'MRL' AND t.ID = q.STD_SURVEY_TYPE_ID AND q.SORT_ORDER = 2)
----1
SET @choice = @choice + 1 

INSERT INTO [V5_Registry].[dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, 'Unilateral foot', '- Unilateral foot', 1, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())
---2
SET @choice = @choice + 1 

INSERT INTO [V5_Registry].[dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, 'Bilateral foot', '- Bilateral foot', 2, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())
---3
SET @choice = @choice + 1 

INSERT INTO [V5_Registry].[dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, 'Unilateral below knee', '- Unilateral below knee', 3, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())
---4
SET @choice = @choice + 1 

INSERT INTO [V5_Registry].[dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, 'Bilateral below knee', '- Bilateral below knee', 4, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())
SET @maxchoice = (SELECT MAX(STD_QUESTION_CHOICE_ID) from [V5_Registry].[dbo].[STD_QUESTION_CHOICE])
---5
SET @choice = @choice + 1 

INSERT INTO [V5_Registry].[dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, 'Unilateral above knee', '- Unilateral above knee', 5, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())
---6
SET @choice = @choice + 1 

INSERT INTO [V5_Registry].[dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, 'Bilateral above knee', '- Bilateral above knee', 6, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())
---7
SET @choice = @choice + 1 

INSERT INTO [V5_Registry].[dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
    ( @choice, @question, 'Bilateral - foot + below knee ', '- Bilateral - foot + below knee', 7, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())
---8
SET @choice = @choice + 1 

INSERT INTO [V5_Registry].[dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
    ( @choice, @question, 'Bilateral - foot + above knee', '- Bilateral - foot + above knee', 8, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())
---9
SET @choice = @choice + 1 

INSERT INTO [V5_Registry].[dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
     (@choice, @question, 'Bilateral - above knee + below knee', '- Bilateral - above knee + below knee', 9, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())

--------Question 3  
 
SELECT @question=  (SELECT q.ID  
FROM STD_QUESTION q
    ,STD_SURVEY_TYPE t
WHERE CODE = 'MRL' AND t.ID = q.STD_SURVEY_TYPE_ID AND q.SORT_ORDER = 3)
----1
SET @choice = ((SELECT MAX(STD_QUESTION_CHOICE_ID) from [V5_Registry].[dbo].[STD_QUESTION_CHOICE]) + 1)

INSERT INTO [V5_Registry].[dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, 'Yes' ,'Yes', 2, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())
----2
SET @choice = @choice + 1 

INSERT INTO [V5_Registry].[dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, 'No', 'No', 1, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())
           
--------Question 4

SELECT @question=  (SELECT q.ID  
FROM STD_QUESTION q
    ,STD_SURVEY_TYPE t
WHERE CODE = 'MRL' AND t.ID = q.STD_SURVEY_TYPE_ID AND q.SORT_ORDER = 4)
----1
SET @choice = @choice + 1 
 INSERT INTO [V5_Registry].[dbo].[STD_QUESTION_CHOICE]
               ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
               ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, 'Walker', 'Walker', 1, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())
----2
SET @choice = @choice + 1 

INSERT INTO [V5_Registry].[dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, 'Rolling Walker', 'Rolling Walker', 2, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())
----3
SET @choice = @choice + 1 

INSERT INTO [V5_Registry].[dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, 'Crutches', 'Crutches', 3, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())
----4
SET @choice = @choice + 1 

INSERT INTO [V5_Registry].[dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, 'Cane', 'Cane', 4, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())

--------Question 5

SELECT @question=  (SELECT q.ID  
FROM STD_QUESTION q
    ,STD_SURVEY_TYPE t
WHERE CODE = 'MRL' AND t.ID = q.STD_SURVEY_TYPE_ID AND q.SORT_ORDER = 5)
----1
SET @choice = @choice + 1 
INSERT INTO [V5_Registry].[dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, 'Yes (Contact Guarding through any level of assistance)', '- Yes (Contact Guarding through any level of assistance)',
            2, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())
----2
SET @choice = @choice + 1 

INSERT INTO [V5_Registry].[dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, 'No (Supervised ambulation through Independent ambulation)', '- No (Supervised ambulation through Independent ambulation)',
            1, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())

--------Question 6

SELECT @question=  (SELECT q.ID  
FROM STD_QUESTION q
    ,STD_SURVEY_TYPE t
WHERE CODE = 'MRL' AND t.ID = q.STD_SURVEY_TYPE_ID AND q.SORT_ORDER = 6)
----1
SET @choice = @choice + 1 
INSERT INTO [V5_Registry].[dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, 'Time: ', 'Time: ', 1, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())


--------Question 7

SELECT @question=  (SELECT q.ID  
FROM STD_QUESTION q
    ,STD_SURVEY_TYPE t
WHERE CODE = 'MRL' AND t.ID = q.STD_SURVEY_TYPE_ID AND q.SORT_ORDER = 7)
----1
SET @choice = @choice + 1 
INSERT INTO [V5_Registry].[dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, 'Distance: ', 'Distance: ', 1, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())

--------Question 8

SELECT @question=  (SELECT q.ID  
FROM STD_QUESTION q
    ,STD_SURVEY_TYPE t
WHERE CODE = 'MRL' AND t.ID = q.STD_SURVEY_TYPE_ID AND q.SORT_ORDER = 8)
----1
SET @choice = @choice + 1 
INSERT INTO [V5_Registry].[dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, 'Time: ', 'Time: ', 1, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())


--------Question 9

SELECT @question=  (SELECT q.ID  
FROM STD_QUESTION q
    ,STD_SURVEY_TYPE t
WHERE CODE = 'MRL' AND t.ID = q.STD_SURVEY_TYPE_ID AND q.SORT_ORDER = 9)
----1
SET @choice = @choice + 1 
INSERT INTO [V5_Registry].[dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, 'Distance: ', 'Distance: ', 1, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())


--------Question 10  
 
SELECT @question=  (SELECT q.ID  
FROM STD_QUESTION q
    ,STD_SURVEY_TYPE t
WHERE CODE = 'MRL' AND t.ID = q.STD_SURVEY_TYPE_ID AND q.SORT_ORDER = 10)
----1
SET @choice = ((SELECT MAX(STD_QUESTION_CHOICE_ID) from [V5_Registry].[dbo].[STD_QUESTION_CHOICE]) + 1)

INSERT INTO [V5_Registry].[dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, 'Yes' ,'Yes', 2, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())
----2
SET @choice = @choice + 1 

INSERT INTO [V5_Registry].[dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, 'No', 'No', 1, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())

--------Question 11

SELECT @question=  (SELECT q.ID  
FROM STD_QUESTION q
    ,STD_SURVEY_TYPE t
WHERE CODE = 'MRL' AND t.ID = q.STD_SURVEY_TYPE_ID AND q.SORT_ORDER = 11)
----1
SET @choice = @choice + 1 
INSERT INTO [V5_Registry].[dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, 'Test Date: ', 'Test Date: ', 1, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())


--------Question 12

SELECT @question=  (SELECT q.ID  
FROM STD_QUESTION q
    ,STD_SURVEY_TYPE t
WHERE CODE = 'MRL' AND t.ID = q.STD_SURVEY_TYPE_ID AND q.SORT_ORDER = 12)
----1
SET @choice = @choice + 1 
INSERT INTO [V5_Registry].[dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, 'Average Time:', 'Average Time:', 1, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())


--------Question 13

SELECT @question=  (SELECT q.ID  
FROM STD_QUESTION q
    ,STD_SURVEY_TYPE t
WHERE CODE = 'MRL' AND t.ID = q.STD_SURVEY_TYPE_ID AND q.SORT_ORDER = 13)
----1
SET @choice = @choice + 1 
INSERT INTO [V5_Registry].[dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, 'Average Distance:', 'Average Distance:', 1, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())



/*           
SELECT * FROM [V5_Registry].[dbo].STD_SURVEY_TYPE
SELECT * FROM [V5_Registry].[dbo].STD_QUESTION
SELECT * FROM [V5_Registry].[dbo].STD_QUESTION_CHOICE 
*/
END

END